unit DemoStosu;

interface

function CzyToPalindrom(const aTekst: string): Boolean;

implementation

uses
  Generics.Collections, System.SysUtils, Character;

type
  TStosZnakw = TStack<Char>;

function CzyToPalindrom(const aTekst: string): Boolean;
var
  Stos: TStosZnakw;
  C: Char;
  TymczTekst: string;
  i: integer;
  TylkoZnaki: string;
begin
  Stos := TStosZnakw.Create;
  try
    for C in aTekst do
    begin
      if TCharacter.IsLetter(C) then
        Stos.Push(TCharacter.ToLower(C));
    end;

    TymczTekst := '';
    for i := 0 to Stos.Count - 1 do
    begin
      TymczTekst := TymczTekst + Stos.Pop;
    end;

    TylkoZnaki := '';
    for C in aTekst do
    begin
      if TCharacter.IsLetter(C) then
        TylkoZnaki := TylkoZnaki + C.ToLower;
    end;
    Result := TymczTekst = TylkoZnaki;
  finally
    Stos.Free;
  end;
end;

end.

